/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package main

import (
	"chainmaker.org/chainmaker/opennet/servicecommon/logo"
	"cnbn-did/internal/config"
	"cnbn-did/internal/handler"
	"cnbn-did/internal/svc"
	"flag"
	"time"

	"github.com/zeromicro/go-zero/core/conf"
	"github.com/zeromicro/go-zero/core/logx"
	"github.com/zeromicro/go-zero/rest"
)

var configFile = flag.String("f", "etc/cnbn-did.yaml", "the config file")

var (
	Version   string // 从 Makefile 传递的版本信息
	Name      string // 从 Makefile 传递的系统名称信息
	GitCommit string // 从 Makefile 传递的提交哈希
	GitBranch string // 从 Makefile 传递的分支名
	BuildTime string // 从 Makefile 传递的构建时间
)

func main() {
	flag.Parse()
	var c config.Config
	conf.MustLoad(*configFile, &c)
	ctx := svc.NewServiceContext(c)
	server := rest.MustNewServer(c.RestConf)
	defer server.Stop()

	handler.RegisterHandlers(server, ctx, Version, Name, GitCommit, GitBranch, BuildTime)
	formatLog := logo.GetLogo(`   ______   _   __   ____     _   __            ____     ____   ____ 
  / ____/  / | / /  / __ )   / | / /           / __ \   /  _/  / __ \
 / /      /  |/ /  / __  |  /  |/ /  ______   / / / /   / /   / / / /
/ /___   / /|  /  / /_/ /  / /|  /  /_____/  / /_/ /  _/ /   / /_/ / 
\____/  /_/ |_/  /_____/  /_/ |_/           /_____/  /___/  /_____/  
                                                                     `, Version, BuildTime, GitBranch, GitCommit, time.Now().Format(time.DateTime), c.Name)
	logx.Info(formatLog)

	logx.Infof("Starting server at %s:%d...\n", c.Host, c.Port)
	server.Start()
}
