# didi10n 命令行工具
## 一、didi10n命令功能作用

`didi10n`命令包含以下子命令：`all`（运行全接口集成测试）、`apimanage`（api manage相关接口集成测试）、`gen`（生成did）、`regold`（老版本注册个人实名接口）

```shell
weisong@bogon test % didi10n -h                 
A longer description that spans multiple lines and likely contains examples

Usage:
  didi10n [flags]
  didi10n [command]

Available Commands:
  all         Perform all operations
  apimanage   Perform api management
  gen         Perform Gen DID
  help        Help about any command
  regold      Perform old register

Flags:
  -h, --help   help for didi10n

Use "didi10n [command] --help" for more information about a command.

```
## 二、功能介绍
## 2.1 所有接口集成测试 

```shell
weisong@bogon test % didi10n all -h 
Perform all operations based on configuration and template files

Usage:
  didi10n all [flags]

Flags:
  -c, --config string     path to config file (required)
  -z, --contract          include contract
  -h, --help              help for all
  -t, --template string   path to template file (required)
```

完整命令如下：

```shell
didi10n all --config=./etc/config-dev.yaml --template=./etc/100001.json --contract
```

## 2.2 api-manage接口集成测试

```shell
weisong@bogon test % didi10n apimanage -h                                                         
Perform api management based on configuration and template files

Usage:
  didi10n apimanage [flags]

Flags:
  -c, --config string     path to config file (required)
  -z, --contract          include contract
  -h, --help              help for apimanage
  -t, --template string   path to template file (required)

```

完整命令如下：

```shell
 didi10n apimanage --config=./etc/config-dev.yaml --template=./etc/100000.json --contract
```

## 2.3 注册个人实名老版本

```shell
weisong@bogon test % didi10n regold -h
Perform old register based on configuration and template files

Usage:
  didi10n regold [flags]

Flags:
  -c, --config string     path to config file (required)
  -z, --contract          include contract
  -h, --help              help for regold
  -t, --template string   path to template file (required)

```

完整命令如下：

```shell
didi10n regold --config=./etc/config-dev.yaml --template=./etc/100000.json --contract
```

## 2.4 生成did
```shell
weisong@bogon test % didi10n gen -h                                                               
Perform Gen DID based on configuration and template files

Usage:
  didi10n gen [flags]

Flags:
  -c, --config string     path to config file (required)
  -n, --count int         number of something to generate (required)
  -h, --help              help for gen
  -t, --template string   path to template file (required)

```

完整命令如下：

```shell
didi10n gen -n=2 --config=./etc/config-dev.yaml --template=./etc/100000.json
```

## 三、使用示例

### 1. 个人实名认证

```shell
didi10n all --config=./etc/config-dev.yaml --template=./etc/100000.json --contract
```

### 2. 企业实名认证
```shell
didi10n all --config=./etc/config-dev.yaml --template=./etc/100001.json --contract
```

### 3.生成2个企业did

```shell
didi10n gen -n=2 --config=./etc/config-dev.yaml --template=./etc/100001.json
```

### 4.生成2个个人did

```shell
didi10n gen -n=2 --config=./etc/config-dev.yaml --template=./etc/100000.json
```

### 5.个人实名认证（老接口）

```shell
didi10n regold --config=./etc/config-dev.yaml --template=./etc/100000.json --contract
```

### 6.api-manage接口流程

```shell
 didi10n apimanage --config=./etc/config-dev.yaml --template=./etc/100000.json --contract
```

