package command

import (
	"cnbn-did/didi10n/process"

	"github.com/spf13/cobra"
)

var AllCmd = &cobra.Command{
	Use:   "all",
	Short: "Perform all operations",
	Long:  `Perform all operations based on configuration and template files`,
	Run: func(cmd *cobra.Command, args []string) {
		configFile, _ := cmd.Flags().GetString(ParameterConfig)
		templateFile, _ := cmd.Flags().GetString(ParameterTemplate)
		withContract, _ := cmd.Flags().GetBool(ParameterContract)

		err := process.RunAll(configFile, templateFile, withContract)
		if err != nil {
			panic(err)
		}
	},
}

func runAllOperations() error {
	return nil
}
