package command

import (
	api_manage "cnbn-did/didi10n/process"

	"github.com/spf13/cobra"
)

var ApimanageCmd = &cobra.Command{
	Use:   "apimanage",
	Short: "Perform api management",
	Long:  `Perform api management based on configuration and template files`,
	Run: func(cmd *cobra.Command, args []string) {
		configFile, _ := cmd.Flags().GetString(ParameterConfig)
		templateFile, _ := cmd.Flags().GetString(ParameterTemplate)
		withContract, _ := cmd.Flags().GetBool(ParameterContract)

		api_manage.RunApiManage(configFile, templateFile, withContract)
	},
}
