package command

import (
	gen_did "cnbn-did/didi10n/process"

	"github.com/spf13/cobra"
)

var GenCmd = &cobra.Command{
	Use:   "gen",
	Short: "Perform Gen DID",
	Long:  `Perform Gen DID based on configuration and template files`,
	Run: func(cmd *cobra.Command, args []string) {
		configFile, _ := cmd.Flags().GetString(ParameterConfig)
		templateFile, _ := cmd.Flags().GetString(ParameterTemplate)
		count, _ := cmd.Flags().GetInt(ParameterCount)

		gen_did.RunGenerationDid(configFile, templateFile, count)
	},
}

func init() {
	GenCmd.Flags().IntP(ParameterCount, "n", 0, "number of something to generate (required)")
}
