package command

import (
	"cnbn-did/didi10n/process"

	"github.com/spf13/cobra"
)

var RegoldCmd = &cobra.Command{
	Use:   "regold",
	Short: "Perform old register",
	Long:  `Perform old register based on configuration and template files`,
	Run: func(cmd *cobra.Command, args []string) {
		configFile, _ := cmd.Flags().GetString(ParameterConfig)
		templateFile, _ := cmd.Flags().GetString(ParameterTemplate)
		withContract, _ := cmd.Flags().GetBool(ParameterContract)

		process.RunRegisterOld(configFile, templateFile, withContract)
	},
}
