package main

import (
	"cnbn-did/didi10n/command"
	"fmt"
	"os"

	"github.com/spf13/cobra"
)

var rootCmd = &cobra.Command{
	Use:   "didi10n",
	Short: "A brief description of your application",
	Long:  `A longer description that spans multiple lines and likely contains examples`,
}

func main() {
	rootCmd.AddCommand(command.AllCmd)
	rootCmd.AddCommand(command.GenCmd)
	rootCmd.AddCommand(command.ApimanageCmd)
	rootCmd.AddCommand(command.RegoldCmd)

	rootCmd.PersistentFlags().StringP(command.ParameterConfig, "c", "", "path to config file (required)")
	rootCmd.PersistentFlags().StringP(command.ParameterTemplate, "t", "", "path to template file (required)")
	rootCmd.PersistentFlags().BoolP(command.ParameterContract, "", false, "enable contract process")

	_ = rootCmd.MarkPersistentFlagRequired(command.ParameterConfig)
	_ = rootCmd.MarkPersistentFlagRequired(command.ParameterTemplate)
	if err := rootCmd.Execute(); err != nil {
		fmt.Println(err)
		os.Exit(1)
	}
}
