package process

import (
	"cnbn-did/didi10n/service"
	"fmt"

	"github.com/zeromicro/go-zero/core/logx"
)

func RunAll(configFile, templateFile string, withContract bool) error {
	runtime, err := service.RuntimeInit(configFile, templateFile)
	if err != nil {
		return err
	}

	instance := service.NewIntegration(runtime)

	logx.Info(fmt.Sprintf("是否执行合约: %v", withContract))

	privateKey, response, doc, err := instance.Register()
	if err != nil {
		return err
	}

	instance.PrivateKey = privateKey
	instance.Document = doc

	vc, err := instance.GenerateVc(doc, instance.Runtime.Template)
	if err != nil {
		return err
	}

	res, err := instance.DocumentRegister(response, vc, doc)
	if err != nil {
		return err
	}

	err = instance.AddPublicKeyUserService()
	if err != nil {
		return err
	}

	err = instance.AddPublicKeyService()
	if err != nil {
		return err
	}

	plaintext, err := instance.AddDeleteService()
	if err != nil {
		return err
	}

	err = instance.UpdateDocumentUser(plaintext)
	if err != nil {
		return err
	}
	err = instance.GetVcListService()
	if err != nil {
		return err
	}

	_, err = instance.GetVcListUser()
	if err != nil {
		return err
	}

	err = instance.Login(res.Data.Vc)
	if err != nil {
		return err
	}

	err = instance.GetDidDocument()
	if err != nil {
		return err
	}

	err = instance.GetDidDocumentByAddress(doc)
	if err != nil {
		return err
	}

	err = instance.CheckBlackList()
	if err != nil {
		return err
	}

	err = instance.GetListDidDocument()
	if err != nil {
		return err
	}

	if instance.Runtime.Template.TemplateId == "100001" {
		err = instance.FindDidByCompanyName(res.Data.Vc)
		if err != nil {
			return err
		}
	}

	err = instance.CreateVcTemplate()
	if err != nil {
		return err
	}

	vcTemplateId, err := instance.CreateVcTemplateByVp()
	if err != nil {
		return err
	}

	err = instance.UpgradeVcTemplateByVp(vcTemplateId)
	if err != nil {
		return err
	}

	err = instance.OneQueryVcTemplate()
	if err != nil {
		return err
	}

	err = instance.PageVcTemplate()
	if err != nil {
		return err
	}

	err = instance.CheckRevokeList()
	if err != nil {
		return err
	}

	err = instance.VcIssue(res.Data.Vc.Id)
	if err != nil {
		return err
	}

	err = instance.GetVcIssuer("did:cndid:cndid")
	if err != nil {
		return err
	}

	err = instance.VcRevoke(res.Data.Vc.Id)
	if err != nil {
		return err
	}

	addSk, err := instance.UpdateAdd()
	if err != nil {
		return err
	}

	err = instance.UpdateDelete(addSk)
	if err != nil {
		return err
	}

	if withContract {
		err = instance.GetDidByAddressFromContract(doc)
		if err != nil {
			return err
		}

		err = instance.GetVcIssuersFromContract()
		if err != nil {
			return err
		}

		err = instance.GetDidDocumentFromContract()
		if err != nil {
			return err
		}

		err = instance.VcIssueLogFromContract()
		if err != nil {
			return err
		}
	}

	return nil
}
