package process

import (
	"cnbn-did/didi10n/service"
	"fmt"

	"github.com/zeromicro/go-zero/core/logx"
)

func RunApiManage(configFile, templateFile string, withContract bool) {
	runtime, err := service.RuntimeInit(configFile, templateFile)
	if err != nil {
		panic(err)
	}

	instance := service.NewIntegration(runtime)

	logx.Info(fmt.Sprintf("是否执行合约: %v", withContract))

	privateKey, response, doc, err := instance.Register()
	if err != nil {
		panic(err)
	}

	instance.PrivateKey = privateKey
	instance.Document = doc

	vc, err := instance.GenerateVc(doc, instance.Runtime.Template)
	if err != nil {
		panic(err)
	}

	_, err = instance.DocumentRegister(response, vc, doc)
	if err != nil {
		panic(err)
	}

	err = instance.VcList()
	if err != nil {
		panic(err)
	}

	err = instance.VerifyRandom()
	if err != nil {
		panic(err)
	}

	if withContract {
		err = instance.GetDidByAddressFromContract(doc)
		if err != nil {
			panic(err)
		}

		err = instance.GetVcIssuersFromContract()
		if err != nil {
			panic(err)
		}

		err = instance.GetDidDocumentFromContract()
		if err != nil {
			panic(err)
		}

		err = instance.VcIssueLogFromContract()
		if err != nil {
			panic(err)
		}

	}

}
