package process

import (
	"cnbn-did/didi10n/service"
	"fmt"

	"github.com/zeromicro/go-zero/core/logx"
)

func RunRegisterOld(configFile, templateFile string, withContract bool) {
	runtime, err := service.RuntimeInit(configFile, templateFile)
	if err != nil {
		panic(err)
	}

	instance := service.NewIntegration(runtime)

	logx.Info(fmt.Sprintf("是否执行合约: %v", withContract))

	privateKey, doc, err := instance.RegisterOld()
	if err != nil {
		panic(err)
	}

	instance.PrivateKey = privateKey
	instance.Document = doc

	if withContract {
		err = instance.GetVcIssuersFromContract()
		if err != nil {
			panic(err)
		}

		err = instance.GetDidDocumentFromContract()
		if err != nil {
			panic(err)
		}

		err = instance.VcIssueLogFromContract()
		if err != nil {
			panic(err)
		}

	}
}
