/*
Created by guoxin in 2024/4/30 下午6:34
*/
package service

import (
	"chainmaker.org/chainmaker/common/v2/json"
	"chainmaker.org/chainmaker/opennet/did/contract"
	"chainmaker.org/chainmaker/opennet/servicecommon/cmclient"
	"cnbn-did/didi10n/config"
	"fmt"
	"github.com/zeromicro/go-zero/core/logx"
)

type Runtime struct {
	Config      *config.Config
	Template    *config.TemplateConfig
	cmdid       contract.CMDID
	cmdidOption contract.CMDIDOption
}

func RuntimeInit(configFile, templateFile string) (*Runtime, error) {
	conf, err := config.ReadConfig(configFile)
	if err != nil {
		return nil, err
	}
	logx.MustSetup(conf.Log.ToLogConf())

	bytes, _ := json.MarshalIndent(conf, "", "    ")
	logx.Info(fmt.Sprintf("执行环境为: %+v", string(bytes)))

	template, err := config.ReadTemplate(templateFile)
	if err != nil {
		return nil, err
	}

	bytes, _ = json.MarshalIndent(template, "", "    ")
	logx.Info(fmt.Sprintf("Vc模板: %+v", string(bytes)))

	client, err := cmclient.CreateCMClient(conf.Chainmaker.SdkConfigPath)
	if err != nil {
		return nil, err
	}
	//  TODO 公司名称随机
	//if entName, ok := template.CredentialSubject["entname"].(string); ok && entName != "" {
	//	template.CredentialSubject["entname"] = entName + strconv.FormatInt(time.Now().Unix(), 10)
	//}
	runtime := &Runtime{
		Config:      conf,
		Template:    template,
		cmdid:       contract.NewCMDIDService(client, conf.Chainmaker.ContractName),
		cmdidOption: contract.NewCMDIDOptionService(client, conf.Chainmaker.ContractName),
	}

	return runtime, nil
}
