package service

import (
	"cnbn-did/didi10n/tools"
	"cnbn-did/internal/types"
	"encoding/json"
)

func (i *Integration) AddDeleteService() (plaintext []byte, err error) {
	req := &types.GenUpdateDocumentServiceRequest{
		Did: i.Document.Id,
		Service: types.Service{
			Id:              i.Document.Id + "#service-2",
			ServiceEndpoint: "http:1111111",
			Type:            "",
		},
		Action: 0,
	}
	url := i.Runtime.Config.CNBNDID + "/api/v1/did/generate/service/0"
	body, err := tools.SendRequest("删除、更新Service", url, req, i.Runtime.Config.CNBNDID)
	if err != nil {
		return
	}
	var result = &types.GenUpdateDocumentResponse{}
	err = json.Unmarshal(body, result)
	if err != nil {
		return
	}

	return result.Data.Plaintext.Plaintext, nil
}
