package service

import (
	"chainweaver.org.cn/chainweaver/did/core"
	"cnbn-did/didi10n/tools"
	"cnbn-did/internal/types"
)

func (i *Integration) AddPublicKeyService() (err error) {
	private, _, pk, err := GenerateKeyPair()
	address, err := core.GetPkAddress(private.PublicKey())
	if err != nil {
		return err
	}
	req := &types.GenUpdateDocumentVerificationMethodRequest{
		Did:       i.Document.Id,
		PublicKey: []string{pk},
		Addresses: []string{address},
		Action:    0,
	}
	url := i.Runtime.Config.CNBNDID + "/api/v1/did/generate/public-key/0"
	_, err = tools.SendRequest("外部添加公钥", url, req, i.Runtime.Config.CNBNDID)
	if err != nil {
		return
	}

	return nil
}
