package service

import (
	"cnbn-did/didi10n/tools"
	"cnbn-did/internal/types"
)

func (i *Integration) AddPublicKeyUserService() (err error) {
	_, _, pk, err := GenerateKeyPair()
	req := &types.DocumentAddPublicKeyRequest{
		Did:       i.Document.Id,
		PublicKey: pk,
	}
	url := i.Runtime.Config.CNBNDID + "/api/v1/did/inner/document/public-key/add"
	_, err = tools.SendRequest("内部添加公钥", url, req, i.Runtime.Config.CNBNDID)
	if err != nil {
		return
	}

	return nil
}
