package service

import (
	"cnbn-did/didi10n/tools"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

func (i *Integration) CheckBlackList() (err error) {
	didList := make([]string, 2)
	didList[0] = i.Document.Id
	didList[1] = DefaultIssuer
	req := &types.CheckRequest{Did: didList}
	_, err = tools.SendRequest("查询did列表是否在黑名单中", i.Runtime.Config.CNBNDID+"/api/v1/did/blacklist/check", req, i.Runtime.Config.CNBNDID)
	if err != nil {
		return
	}
	logx.Info("=======================================查询did列表是否在黑名单完成======================================")
	return
}
