package service

import (
	"cnbn-did/didi10n/tools"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

func (i *Integration) CreateVcTemplate() (err error) {
	req := &types.VcTemplateSaveRequest{
		Name:     "长安链企业实名认证证书",
		Versions: "v1.0",
		Creator:  DefaultIssuer,
		VcType:   "IdentityCredential",
		Properties: map[string]types.PropertyObj{
			"id": {
				Type:    "string",
				Title:   "⽤户DID",
				Pattern: ".+",
				Desc:    "字段描述",
			},
			"issuerName": {
				Type:  "string",
				Title: "签发机构名称",
			},
			"certificateName": {
				Type:  "string",
				Title: "证书名称",
			},
			// 其他属性依此类推
		},
		Required: []string{
			"id",
			"issuerName",
			"certificateName",
			// 其他必填属性依此类推
		},
		AdditionalProperties: true,
	}

	url := i.Runtime.Config.CNBNDID + "/api/v1/did/vctemplate/create"
	_, err = tools.SendRequest("创建vc template", url, req, i.Runtime.Config.CNBNDID)
	if err != nil {
		return
	}
	logx.Info("=======================================创建vc template完成======================================")
	return
}
