package service

import (
	"cnbn-did/didi10n/tools"
	"cnbn-did/internal/types"
	"encoding/json"

	"chainmaker.org/chainmaker/opennet/servicecommon/copier"
	"chainweaver.org.cn/chainweaver/did/core"
	corecrypto "chainweaver.org.cn/chainweaver/did/core/crypto"
	"github.com/zeromicro/go-zero/core/logx"
)

func (i *Integration) DocumentRegister(result *types.GenDocumentRegisterResponse, vc *types.VcIssueRequest, doc *core.Document) (res *types.DocumentRegisterResponse, err error) {
	documentProof, err := corecrypto.NewSigner(i.PrivateKey, doc.Authentication[0]).Plaintext(result.Data.Plaintext)
	if err != nil {
		return
	}

	typesDocumentProof := types.Proof{}
	err = copier.Copy(documentProof, &typesDocumentProof)
	if err != nil {
		return
	}

	document := &types.DocumentRegisterRequest{
		Did:   result.Data.Did,
		Proof: typesDocumentProof,
		Issue: vc,
	}

	url := i.Runtime.Config.CNBNDID + "/api/v1/did/document/register"

	body, err := tools.SendRequest("注册-注册did ", url, document, i.Runtime.Config.CNBNDID)
	if err != nil {
		return
	}
	res = &types.DocumentRegisterResponse{}
	err = json.Unmarshal(body, res)
	if err != nil {
		return
	}
	logx.Info("=======================================注册完成======================================")
	return
}
