package service

import (
	"cnbn-did/didi10n/tools"
	"cnbn-did/internal/types"
	"encoding/json"
	"errors"

	"chainmaker.org/chainmaker/opennet/servicecommon/copier"
	"chainweaver.org.cn/chainweaver/did/core"
	"github.com/zeromicro/go-zero/core/logx"
)

type CredentialSubject struct {
	CertificateName string `json:"certificateName"`
	Dom             string `json:"dom"`
	EntName         string `json:"entname"`
	ID              string `json:"id"`
	IssuerName      string `json:"issuerName"`
	LegalName       string `json:"legalName"`
	LicenceSN       string `json:"licencesn"`
	Operator        string `json:"operator"`
	OpFrom          string `json:"opfrom"`
	Opscope         string `json:"opscope"`
	OpTo            string `json:"opto"`
	UniscID         string `json:"uniscid"`
}

func (i *Integration) FindDidByCompanyName(typeVc *types.VerifiableCredential) (err error) {
	coreVc := &core.VerifiableCredential{}
	err = copier.Copy(typeVc, coreVc)
	if err != nil {
		return
	}
	var credentialSubject CredentialSubject
	err = json.Unmarshal(coreVc.CredentialSubject, &credentialSubject)
	if err != nil {
		return
	}
	findDIDByCompanyNameReq := types.FindDIDByCompanyNameRequest{CompanyName: credentialSubject.EntName}
	url := i.Runtime.Config.CNBNDID + "/api/v1/did/vc/find-did-by-company-name"
	body, err := tools.SendRequest("根据公司名查询did", url, findDIDByCompanyNameReq, i.Runtime.Config.CNBNDID)
	if err != nil {
		return
	}
	var findDIDByCompanyNameRes types.FindDIDByCompanyNameResponse
	err = json.Unmarshal(body, &findDIDByCompanyNameRes)
	if err != nil {
		return
	}

	if findDIDByCompanyNameRes.Data.Did == i.Document.Id {
		logx.Info("=======================================根据公司名查询did完成======================================")
		return nil
	} else {
		return errors.New("根据公司名查询did查询结果不正确")
	}
}
