package service

import (
	"cnbn-did/didi10n/config"
	"cnbn-did/internal/types"
	"encoding/json"
	"strconv"
	"time"

	vo "chainmaker.org/chainmaker/opennet/did/vo/did"
	"chainmaker.org/chainmaker/opennet/servicecommon/copier"
	"chainweaver.org.cn/chainweaver/did/core"
	corecrypto "chainweaver.org.cn/chainweaver/did/core/crypto"
)

func (i *Integration) GenerateVc(doc *core.Document, template *config.TemplateConfig) (vc *types.VcIssueRequest, err error) {
	vcPlaintext := []byte(strconv.FormatInt(time.Now().Unix(), 10))
	vcProof, err := corecrypto.NewSigner(i.PrivateKey, doc.Authentication[0]).Plaintext(vcPlaintext)
	if err != nil {
		return
	}

	typesVcProof := types.Proof{}
	err = copier.Copy(vcProof, &typesVcProof)
	if err != nil {
		return nil, err
	}
	issueDate := time.Now()
	expirationDate := issueDate.AddDate(3, 0, 0)

	sjBytes, err := json.Marshal(template.CredentialSubject)
	if err != nil {
		return nil, err
	}

	vcIssue := &types.VcIssueRequest{
		TemplateId:        template.TemplateId,
		Holder:            doc.GetId(),
		ExpirationDate:    core.Format(expirationDate),
		IssuanceDate:      core.Format(issueDate),
		CredentialSubject: sjBytes,
		Proof: []types.LongProof{{
			Type: int32(vo.ProofType_VerifyVP),
			Proof: types.SODProof{
				Proof:     typesVcProof,
				Plaintext: vcPlaintext,
			},
		}},
	}

	return vcIssue, nil
}
