package service

import (
	"cnbn-did/didi10n/tools"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

func (i *Integration) GetDidDocument() (err error) {
	req := &types.DocumentGetRequest{Did: i.Document.Id}
	_, err = tools.SendRequest("查询document", i.Runtime.Config.CNBNDID+"/api/v1/did/document/get", req, i.Runtime.Config.CNBNDID)
	if err != nil {
		return
	}
	logx.Info("=======================================查询document完成======================================")

	return
}
