package service

import (
	"cnbn-did/didi10n/tools"
	"cnbn-did/internal/types"

	"chainweaver.org.cn/chainweaver/did/core"
	"github.com/zeromicro/go-zero/core/logx"
)

func (i *Integration) GetDidDocumentByAddress(doc *core.Document) (err error) {
	//address, err := core.GetPkAddress(publicKey)
	req := &types.DocumentGetByAddressRequest{Address: doc.VerificationMethod[0].Address}
	_, err = tools.SendRequest("根据address获取document", i.Runtime.Config.CNBNDID+"/api/v1/did/document/get-by-address", req, i.Runtime.Config.CNBNDID)
	if err != nil {
		return
	}
	logx.Info("=======================================根据address获取document完成======================================")
	return
}
