package service

import (
	"encoding/json"
	"fmt"

	"chainweaver.org.cn/chainweaver/did/core"
	"github.com/zeromicro/go-zero/core/logx"
)

func (i *Integration) GetDidDocumentFromContract() (err error) {
	r, err := i.Runtime.cmdid.GetDidDocument(i.Document.Id)
	if err != nil {
		return err
	}
	doc := &core.Document{}
	err = json.Unmarshal([]byte(r), doc)
	if err != nil {
		return err
	}
	if doc.Id == i.Document.Id {
		logx.Info("=======================================GetDidDocument合约完成======================================")
	} else {
		return fmt.Errorf("Document中的DID与目标DID不一致")
	}
	return
}
