package service

import (
	"cnbn-did/didi10n/tools"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

func (i *Integration) GetListDidDocument() (err error) {
	didList := make([]string, 2)
	didList[0] = i.Document.Id
	didList[1] = DefaultIssuer
	req := &types.DocumentGetListRequest{Did: didList}
	_, err = tools.SendRequest("批量查询document", i.Runtime.Config.CNBNDID+"/api/v1/did/document/list", req, i.Runtime.Config.CNBNDID)
	if err != nil {
		return
	}
	logx.Info("=======================================批量查询document完成======================================")
	return
}
