package service

import (
	"cnbn-did/didi10n/tools"
	"cnbn-did/internal/types"
)

func (i *Integration) GetVcIssueList() (err error) {
	req := &types.IssueLogGetVcIssueLogsRequest{
		Page: types.Page{
			Page:  1,
			Size:  2,
			Total: 2,
		},
		Holder:     i.Document.Id,
		Issuer:     DefaultIssuer,
		TemplateId: DefaultTemplateID,
	}
	_, err = tools.SendRequest("获取vc issue列表", i.Runtime.Config.CNBNDID+"/api/v1/did/issue-log/list", req, i.Runtime.Config.CNBNDID)
	if err != nil {
		return
	}
	return
}
