package service

import (
	"fmt"

	"github.com/zeromicro/go-zero/core/logx"
)

func (i *Integration) GetVcIssuersFromContract() (err error) {
	r, err := i.Runtime.cmdidOption.GetVcIssuers(i.Document.Id)
	if err != nil {
		return err
	}
	flag := false
	for _, issuer := range r {
		if issuer == DefaultIssuer {
			flag = true
			break
		}
	}
	if flag == false {
		return fmt.Errorf("VcIssuers中不包含did:cndid:cndid")
	}
	logx.Info("=======================================GetVcIssuers合约完成======================================")
	return
}
