package service

import (
	"cnbn-did/didi10n/tools"
	"cnbn-did/internal/types"
	"encoding/json"
)

func (i *Integration) ImportDidDocument() (err error) {
	docString := `{
	"document": {
		"@context": [
			"https://www.w3.org/ns/did/v1"
		],
		"authentication": [
			"did:cndid:0420f837b03c4e5488421e3069da135b#key-1"
		],
		"controller": [
			"did:cndid:cndid",
			"did:cndid:0420f837b03c4e5488421e3069da135b"
		],
		"created": "2024-04-15T19:15:15+08:00",
		"id": "did:cndid:0420f837b03c4e5488421e3069da135b",
		"proof": [
			{
				"created": "2024-04-15T19:15:14+08:00",
				"proofValue": "MEUCIGT43lsI6fmcuQy2tbLVDMsgzwDOjv3u4ZfCKAhzZLPPAiEAjiJYd0N6Yw6PedF8gbGlnUD8O6/QEfJGDfM+aNk3+a8=",
				"type": "SM2Signature2022",
				"verificationMethod": "did:cndid:0420f837b03c4e5488421e3069da135b#key-1"
			}
		],
		"updated": "2024-04-15T19:15:15+08:00",
		"verificationMethod": [
			{
				"address": "e606fbf5de3b758321d77a44e5cf372ff070dbf4",
				"controller": "did:cndid:0420f837b03c4e5488421e3069da135b",
				"id": "did:cndid:0420f837b03c4e5488421e3069da135b#key-1",
				"publicKeyPem": "-----BEGIN PUBLIC KEY-----\nMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAEYtAgq4n5UYcWsW4M00oiwkZTu1HP\nlsxS373AMckXcAF1/KuRiKz2k2iYf8UtkWgwmu+3Pa3BUyZ3ypYUydTzNA==\n-----END PUBLIC KEY-----\n",
				"type": "SM2VerificationKey2022"
			}
		]
	}
}`
	var document types.Document
	err = json.Unmarshal([]byte(docString), &document)
	if err != nil {
		panic(err)
	}

	reqImport := &types.DocumentImportRequest{
		Password: DefaultPassword,
		Document: document,
	}

	_, err = tools.SendRequest("导入document", i.Runtime.Config.CNBNDID+"/api/v1/did/document/import", reqImport, i.Runtime.Config.CNBNDID)
	if err != nil {
		return
	}
	return
}
