package service

import (
	"cnbn-did/didi10n/tools"
	"cnbn-did/internal/types"
	"encoding/json"
	"time"

	"chainmaker.org/chainmaker/common/v2/random/uuid"
	"chainmaker.org/chainmaker/opennet/servicecommon/copier"
	"chainweaver.org.cn/chainweaver/did/core"
	corecrypto "chainweaver.org.cn/chainweaver/did/core/crypto"
	"github.com/zeromicro/go-zero/core/logx"
)

const TableNameVc = "vc"

// Vc 国家区块链网络 Verifiable Credential 电子凭证表
type Vc struct {
	ID         string    `gorm:"column:id;primaryKey;comment:唯一主键" json:"id"`                                                    // 唯一主键
	Holder     string    `gorm:"column:holder;not null;index:idx_holder,priority:1;comment:持证人DID" json:"holder"`                // 持证人DID
	Issuer     string    `gorm:"column:issuer;not null;index:idx_issuer,priority:1;comment:发证人DID" json:"issuer"`                // 发证人DID
	TemplateID string    `gorm:"column:template_id;not null;index:idx_template_id,priority:1;comment:VC模板ID" json:"template_id"` // VC模板ID
	Subject    string    `gorm:"column:subject;not null;comment:凭证主体" json:"subject"`                                            // 凭证主体
	Credential string    `gorm:"column:credential;not null;comment:凭证" json:"credential"`                                        // 凭证
	Issuance   time.Time `gorm:"column:issuance;not null;comment:签发时间" json:"issuance"`                                          // 签发时间
	Expiration time.Time `gorm:"column:expiration;not null;comment:过期时间" json:"expiration"`                                      // 过期时间
	Status     int32     `gorm:"column:status;not null;index:idx_status,priority:1;comment:VC状态 正常: 0, 吊销: 1" json:"status"`     // VC状态 正常: 0, 吊销: 1
	Created    time.Time `gorm:"column:created;not null;default:CURRENT_TIMESTAMP;comment:创建时间" json:"created"`                  // 创建时间
}

// TableName Vc's table name
func (*Vc) TableName() string {
	return TableNameVc
}

func (i *Integration) Login(vc *types.VerifiableCredential) (err error) {
	//验证CNBN机构合法性（生成VP）
	logx.Debugf("1.第三方生成VP")

	t1 := &types.GenVerifyVPRequest{Extend: map[string]interface{}{
		"appId": "c0e37c34-fd37-4811-9939-7d5647f8a5d6",
	}}

	body, err := tools.SendRequest("登录-生成vp", i.Runtime.Config.CNBNDID+"/api/v1/did/generate/cnbn-vp", t1, i.Runtime.Config.CNBNDID)
	if err != nil {
		return
	}

	logx.Debugf("2.CNBN验证第三方VP")

	var result = &types.GenCnbnVpResponse{}
	err = json.Unmarshal(body, result)
	if err != nil {
		return
	}

	url := i.Runtime.Config.CNBNDID + "/api/v1/did/verify/vp"
	body, err = tools.SendRequest("登录-校验vp", url, result.Data.Vp, i.Runtime.Config.CNBNDID)
	if err != nil {
		return
	}

	logx.Debugf("3.用户生成VP(无VC)")

	now := time.Now()
	afterTenMinutes := now.Add(time.Minute * 10)
	vp1 := core.NewVerifiablePresentationBytesExtend(
		core.DefaultVCContext,
		uuid.GetUUID(),
		DefaultIssuer,
		core.VPType,
		"VerificationAuthorityLegitimacy",
		nil,
		nil,
		afterTenMinutes,
		nil,
	)

	bytes, err := json.Marshal(vp1)
	if err != nil {
		return
	}

	err = corecrypto.NewSigner(i.PrivateKey, i.Document.Id+"#key-1").Vp(vp1)
	if err != nil {
		return
	}

	marshal, err := json.Marshal(vp1)
	if err != nil {
		return
	}

	logx.Debugf("VP: %v", string(marshal))

	logx.Debugf("4. 调用验证接口，验证VP（无VC）")
	body, err = tools.SendRequest("登录-校验vp（无vc）", url, vp1, i.Runtime.Config.CNBNDID)
	if err != nil {
		return
	}

	logx.Debugf("5.用户生成VP(有VC)")

	//var vc Vc
	//if err = db.Where("holder = ?", did).First(&vc).Error; err != nil {
	//	logx.Error(err)
	//	return
	//}

	vcList := make([]*core.VerifiableCredential, 1)
	coreVc := &core.VerifiableCredential{}
	err = copier.Copy(vc, coreVc)
	if err != nil {
		return err
	}

	vcList[0] = coreVc

	now = time.Now()
	afterTenMinutes = now.Add(time.Minute * 10)
	vp2 := core.NewVerifiablePresentationBytesExtend(
		core.DefaultVCContext,
		uuid.GetUUID(),
		i.Document.Id,
		core.VPType,
		"VerificationAuthorityLegitimacy",
		vcList,
		nil,
		afterTenMinutes,
		nil,
	)

	bytes, err = json.Marshal(vp2)
	if err != nil {
		return
	}

	err = corecrypto.NewSigner(i.PrivateKey, i.Document.Id+"#key-1").Vp(vp2)
	if err != nil {
		return
	}

	bytes, err = json.Marshal(vp2)
	if err != nil {
		return
	}

	logx.Debugf("VP: %v", string(bytes))

	logx.Debugf("6.第三方验证用户的VP(有VC)")
	body, err = tools.SendRequest("登录-校验vp（有vc）", url, vp2, i.Runtime.Config.CNBNDID)
	if err != nil {
		return
	}
	logx.Info("=======================================登录完成======================================")
	return
}
