package service

import (
	"cnbn-did/didi10n/tools"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

func (i *Integration) PageVcTemplate() (err error) {
	pageReq := &types.VcTemplatePageRequest{
		Id:       DefaultTemplateID,
		Name:     "长安链",
		Versions: "v1.0",
		Page: types.Page{
			Page: 1,
			Size: 10,
		},
	}

	_, err = tools.SendRequest("查询vc template", i.Runtime.Config.CNBNDID+"/api/v1/did/vctemplate/list", pageReq, i.Runtime.Config.CNBNDID)
	if err != nil {
		return
	}
	logx.Info("=======================================分页查询vc template完成======================================")
	return
}
