package service

import (
	"cnbn-did/didi10n/tools"
	"cnbn-did/internal/types"
	"encoding/json"

	"chainmaker.org/chainmaker/common/v2/crypto"
	"chainmaker.org/chainmaker/common/v2/crypto/asym"
	"chainweaver.org.cn/chainweaver/did/core"
	"github.com/zeromicro/go-zero/core/logx"
)

func (i *Integration) Register() (privateKey crypto.PrivateKey, documentRegisterResponse *types.GenDocumentRegisterResponse, doc *core.Document, err error) {
	privateKey, sk, pk, err := GenerateKeyPair()
	if err != nil {
		return nil, nil, nil, err
	}

	logx.Info("私钥：\n%v\n", sk)
	logx.Info("公钥：\n%v\n", pk)

	url := i.Runtime.Config.CNBNDID + "/api/v1/did/generate/register"

	//req := &types.GenDocumentRegisterRequest{
	//	PublicKey: []string{
	//		pk,
	//	},
	//}

	req := &types.GenDocumentRegisterRequest{
		PublicKey: []string{
			pk,
		},
		Service: &types.Service{
			ServiceEndpoint: "http:11111",
		},
	}

	body, err := tools.SendRequest("注册-生成document（new）", url, req, i.Runtime.Config.CNBNDID)
	if err != nil {
		return nil, nil, nil, err
	}

	var result = &types.GenDocumentRegisterResponse{}
	err = json.Unmarshal(body, result)
	if err != nil {
		return nil, nil, nil, err
	}

	doc = &core.Document{}
	err = json.Unmarshal(result.Data.Plaintext, doc)
	if err != nil {
		return nil, nil, nil, err
	}

	return privateKey, result, doc, nil
}

func GenerateKeyPair() (privateKey crypto.PrivateKey, sk, pk string, err error) {
	privateKey, err = asym.GenerateKeyPair(crypto.SM2)
	if err != nil {
		return
	}

	sk, err = privateKey.String()
	if err != nil {
		return
	}

	pk, err = privateKey.PublicKey().String()
	if err != nil {
		return
	}
	return
}
