package service

import (
	corecrypto "chainweaver.org.cn/chainweaver/did/core/crypto"
	"cnbn-did/didi10n/tools"
	"cnbn-did/internal/types"
)

func (i *Integration) UpdateDocumentUser(plaintext []byte) (err error) {
	sign, err := corecrypto.NewSigner(i.PrivateKey, i.Document.Id+"#key-1").Plaintext(plaintext)
	if err != nil {
		return
	}

	req := &types.DocumentUpdateRequest{
		Did: i.Document.Id,
		Proof: []types.Proof{{
			Created:            sign.Created,
			ProofPurpose:       sign.ProofPurpose,
			ProofValue:         sign.ProofValue,
			Type:               sign.Type,
			VerificationMethod: sign.VerificationMethod,
		}},
	}
	url := i.Runtime.Config.CNBNDID + "/api/v1/did/document/update"
	_, err = tools.SendRequest("更新doc service", url, req, i.Runtime.Config.CNBNDID)
	if err != nil {
		return
	}
	return
}
