/*
Created by guoxin in 2024/2/27 15:45
*/
package service

import (
	"cnbn-did/didi10n/tools"
	"cnbn-did/internal/types"
	"encoding/json"
	"errors"
	"time"

	"chainmaker.org/chainmaker/common/v2/crypto"
	"chainmaker.org/chainmaker/common/v2/crypto/asym"
	"chainmaker.org/chainmaker/opennet/servicecommon/res/code"
	"chainweaver.org.cn/chainweaver/did/core"
	corecrypto "chainweaver.org.cn/chainweaver/did/core/crypto"
	"github.com/zeromicro/go-zero/core/logx"
)

func (i *Integration) UpdateAdd() (pair crypto.PrivateKey, err error) {
	logx.Debugf("1. 生成秘钥对")
	pair, err = asym.GenerateKeyPair(crypto.SM2)
	if err != nil {
		panic(err)
	}
	key := pair.PublicKey()
	logx.Debugf("私钥：\n%v\n", pair)
	logx.Debugf("公钥：\n%v\n", key)
	pk, err := key.String()
	if err != nil {
		panic(err)
	}

	address, err := core.GetPkAddress(key)
	if err != nil {
		panic(err)
	}

	logx.Debugf("2. 调用生成Document接口（修改VerificationMethod）")
	request := types.GenUpdateDocumentVerificationMethodRequest{
		i.Document.Id,
		[]string{
			pk,
		},
		[]string{address},
		0,
	}
	result, err := tools.SendRequest("更新Add-生成Document接口（修改VerificationMethod)", i.Runtime.Config.CNBNDID+"/api/v1/did/generate/public-key/0", request, i.Runtime.Config.CNBNDID)
	if err != nil {
		panic(err)
	}

	var res types.GenUpdateDocumentResponse
	err = json.Unmarshal(result, &res)
	if err != nil {
		panic(err)
	}

	if code.CodeOk.NotEqualsInt32(res.Code) {
		err = errors.New("/api/v1/did/generate/public-key/0 response not 200" + res.Msg)
		panic(err)
	}
	var doc core.Document
	err = json.Unmarshal(res.Data.Plaintext.Plaintext, &doc)
	if err != nil {
		panic(err)
	}
	logx.Debugf("3. 构建证明结构")
	address, err = core.GetPkAddress(i.PrivateKey.PublicKey())
	if err != nil {
		panic(err)
	}

	var verificationId string
	for _, verificationMethod := range doc.VerificationMethod {
		if verificationMethod.Address == address {
			verificationId = verificationMethod.Id
			break
		}
	}

	proof, err := corecrypto.NewSigner(i.PrivateKey, verificationId).Plaintext(res.Data.Plaintext.Plaintext)
	if err != nil {
		panic(err)
	}

	logx.Debugf("4. 调用更新document接口")

	updateRequest := types.DocumentUpdateRequest{
		Did: i.Document.Id,
		Proof: []types.Proof{{
			Created:            core.Format(time.Now()),
			ProofPurpose:       core.ProofPurpose,
			ProofValue:         proof.ProofValue,
			Type:               core.ProofTypeSM2Signature,
			VerificationMethod: verificationId,
		}},
	}
	updateResult, err := tools.SendRequest("更新Add-更新document", i.Runtime.Config.CNBNDID+"/api/v1/did/document/update", updateRequest, i.Runtime.Config.CNBNDID)
	if err != nil {
		panic(err)
	}

	var docres types.DocumentResponse
	err = json.Unmarshal(updateResult, &docres)
	if err != nil {
		panic(err)
	}
	if code.CodeOk.NotEqualsInt32(docres.Code) {
		panic("/api/v1/did/document/update not 200000" + docres.Msg)
	}
	marshal, err := json.Marshal(docres.Data)
	if err != nil {
		panic(err)
	}
	logx.Debugf(string(marshal))
	logx.Info("=======================================更新add document完成======================================")
	return
}

func (i *Integration) UpdateDelete(delSk crypto.PrivateKey) (err error) {
	logx.Debugf("1. 生成秘钥对")

	key := delSk.PublicKey()
	privateKeyString, err := delSk.String()
	if err != nil {
		return err
	}
	publicKeyString, err := key.String()
	if err != nil {
		return err
	}
	logx.Debugf("私钥：\n%v\n", privateKeyString)
	logx.Debugf("公钥：\n%v\n", publicKeyString)
	pk, err := key.String()
	if err != nil {
		panic(err)
	}

	address, err := core.GetPkAddress(key)
	if err != nil {
		panic(err)
	}

	logx.Debugf("2. 调用生成Document接口（修改VerificationMethod）")
	request := types.GenUpdateDocumentVerificationMethodRequest{
		i.Document.Id,
		[]string{
			pk,
		},
		[]string{address},
		1,
	}
	result, err := tools.SendRequest("更新Del-生成Document接口（修改VerificationMethod", i.Runtime.Config.CNBNDID+"/api/v1/did/generate/public-key/1", request, i.Runtime.Config.CNBNDID)
	if err != nil {
		panic(err)
	}

	var res types.GenUpdateDocumentResponse
	err = json.Unmarshal(result, &res)
	if err != nil {
		panic(err)
	}

	if code.CodeOk.NotEqualsInt32(res.Code) {
		err = errors.New("/api/v1/did/generate/public-key/0 response not 200000" + res.Msg)
		panic(err)
	}
	var doc core.Document
	err = json.Unmarshal(res.Data.Plaintext.Plaintext, &doc)
	if err != nil {
		panic(err)
	}
	logx.Debugf("3. 构建证明结构")
	address, err = core.GetPkAddress(i.PrivateKey.PublicKey())
	if err != nil {
		panic(err)
	}

	var verificationId string
	for _, verificationMethod := range doc.VerificationMethod {
		if verificationMethod.Address == address {
			verificationId = verificationMethod.Id
			break
		}
	}

	proof, err := corecrypto.NewSigner(i.PrivateKey, verificationId).Plaintext(res.Data.Plaintext.Plaintext)
	if err != nil {
		panic(err)
	}

	logx.Debugf("4. 调用更新document接口")

	updateRequest := types.DocumentUpdateRequest{
		Did: i.Document.Id,
		Proof: []types.Proof{{
			Created:            core.Format(time.Now()),
			ProofPurpose:       core.ProofPurpose,
			ProofValue:         proof.ProofValue,
			Type:               core.ProofTypeSM2Signature,
			VerificationMethod: verificationId,
		}},
	}
	updateResult, err := tools.SendRequest("更新Del-更新document", i.Runtime.Config.CNBNDID+"/api/v1/did/document/update", updateRequest, i.Runtime.Config.CNBNDID)
	if err != nil {
		panic(err)
	}

	var docres types.DocumentResponse
	err = json.Unmarshal(updateResult, &docres)
	if err != nil {
		panic(err)
	}
	if code.CodeOk.NotEqualsInt32(docres.Code) {
		panic("/api/v1/did/document/update not 200000" + docres.Msg)
	}
	marshal, err := json.Marshal(docres.Data)
	if err != nil {
		panic(err)
	}
	logx.Debugf(string(marshal))
	logx.Info("=======================================更新del document完成======================================")
	return
}
