package service

import (
	"cnbn-did/didi10n/tools"
	"strings"
	"time"

	"chainmaker.org/chainmaker/common/v2/random/uuid"
	"chainweaver.org.cn/chainweaver/did/core"
	corecrypto "chainweaver.org.cn/chainweaver/did/core/crypto"
)

func (i *Integration) UpgradeVcTemplateByVp(id string) (err error) {
	now := time.Now()
	afterTwoYears := now.AddDate(2, 0, 0)
	//extend := `{\"name\":\"长安链企业实名认证证书\",\"versions\":\"1.0\",\"creator\":\"did:cnbn:cnbn\",\"vcType\":\"IdentityCredential\",\"properties\":{\"id\":{\"type\":\"string\",\"title\":\"⽤户DID\",\"reg\":\".+\",\"desc\":\"字段描述\"},\"issuerName\":{\"type\":\"string\",\"title\":\"签发机构名称\"},\"certificateName\":{\"type\":\"string\",\"title\":\"证书名称\"},\"operator\":{\"type\":\"string\",\"title\":\"操作人\"},\"legalName\":{\"type\":\"string\",\"title\":\"法人\"},\"licencesn\":{\"type\":\"string\",\"title\":\"电子营业执照号\"},\"entname\":{\"type\":\"string\",\"title\":\"企业名称\"},\"opscope\":{\"type\":\"string\",\"title\":\"经营范围\"},\"uniscid\":{\"type\":\"string\",\"title\":\"统一社会信用代码\"},\"dom\":{\"type\":\"string\",\"title\":\"注册地\"},\"opfrom\":{\"type\":\"string\",\"title\":\"经营期限起\"},\"opto\":{\"type\":\"string\",\"title\":\"经验期限止\"}},\"required\":[\"id\",\"issuerName\",\"certificateName\",\"name\",\"identityCardNumber\",\"phone\",\"ctidVc\"],\"additionalProperties\":true}`
	extend := `{
	"id": "100479",
	"name": "长安链企业实名认证证书",
	"versions": "2.0",
	"creator": "did:cndid:cndid",
	"vcType": "IdentityCredential",
	"properties": {
		"id": {
			"type": "string",
			"title": "⽤户DID",
			"pattern": ".+",
			"desc": "字段描述",
			"maxLength":1
		},
		"issuerName": {
			"type": "string",
			"title": "签发机构名称"
		},
		"certificateName": {
			"type": "string",
			"title": "证书名称"
		},
		"operator": {
			"type": "string",
			"title": "操作人"
		},
		"legalName": {
			"type": "string",
			"title": "法人"
		},
		"licencesn": {
			"type": "string",
			"title": "电子营业执照号"
		},
		"entname": {
			"type": "string",
			"title": "企业名称"
		},
		"opscope": {
			"type": "string",
			"title": "经营范围"
		},
		"uniscid": {
			"type": "string",
			"title": "统一社会信用代码"
		},
		"dom": {
			"type": "string",
			"title": "注册地"
		},
		"opfrom": {
			"type": "string",
			"title": "经营期限起"
		},
		"opto": {
			"type": "string",
			"title": "经验期限止"
		}
	},
	"required": [
		"id",
		"issuerName",
		"certificateName",
		"name",
		"identityCardNumber",
		"phone",
		"ctidVc"
	],
	"additionalProperties": false
}`
	extend = strings.Replace(extend, `"id": "100479"`, `"id": "`+id+`"`, 1)

	vp := core.NewVerifiablePresentationBytesExtend(
		core.DefaultVCContext,
		uuid.GetUUID(),
		i.Document.Id,
		core.VPType,
		"VerificationAuthorityLegitimacy",
		nil,
		nil,
		afterTwoYears,
		[]byte(extend))

	err = corecrypto.NewSigner(i.PrivateKey, i.Document.Id+"#key-1").Vp(vp)
	if err != nil {
		return
	}

	url := i.Runtime.Config.CNBNDID + "/api/v1/did/vctemplate/upgrade/vp"
	_, err = tools.SendRequest("通过vp升级vc template", url, vp, i.Runtime.Config.CNBNDID)
	if err != nil {
		return
	}
	return
}
