package service

import (
	"cnbn-did/didi10n/tools"
	"fmt"
	"regexp"
	"strings"
	"time"

	"chainmaker.org/chainmaker/common/v2/random/uuid"
	"chainweaver.org.cn/chainweaver/did/core"
	corecrypto "chainweaver.org.cn/chainweaver/did/core/crypto"
	"github.com/zeromicro/go-zero/core/logx"
)

func (i *Integration) VcIssue(id string) (err error) {
	now := time.Now()
	afterTenMinutes := now.Add(time.Minute * 10)
	extend := `{
		"issuer": "did:cndid:cndid",
		"holder": "did:cndid:cndid",
		"vcId": "8378091daa3d4f08be57b3d7fe6b42c1",
		"templateId": "100000"
	}`

	// 使用正则表达式从 URL 中提取 vcId
	re := regexp.MustCompile(`.*/did/vc/([a-z0-9]+)`)
	matches := re.FindStringSubmatch(id)
	if len(matches) < 2 {
		return fmt.Errorf("no match found for vcId in URL")
	}

	// 替换 extend 字符串中的 vcId 字段
	extend = strings.Replace(extend, `"vcId": "8378091daa3d4f08be57b3d7fe6b42c1"`, `"vcId": "`+matches[1]+`"`, 1)

	vp := core.NewVerifiablePresentationBytesExtend(
		core.DefaultVCContext,
		uuid.GetUUID(),
		i.Document.Id,
		core.VPType,
		"VerificationAuthorityLegitimacy",
		nil,
		nil,
		afterTenMinutes,
		[]byte(extend))

	err = corecrypto.NewSigner(i.PrivateKey, i.Document.Id+"#key-1").Vp(vp)
	if err != nil {
		return
	}

	url := i.Runtime.Config.CNBNDID + "/api/v1/did/vc/register"
	_, err = tools.SendRequest("登记vc", url, vp, i.Runtime.Config.CNBNDID)
	if err != nil {
		return
	}
	logx.Info("=======================================登记vc完成======================================")
	return
}
