package service

import (
	"cnbn-did/didi10n/tools"
	"encoding/json"
	"time"

	"chainmaker.org/chainmaker/common/v2/random/uuid"
	vo "chainmaker.org/chainmaker/opennet/did/vo/did"
	"chainmaker.org/chainmaker/opennet/servicecommon/page"
	"chainweaver.org.cn/chainweaver/did/core"
	corecrypto "chainweaver.org.cn/chainweaver/did/core/crypto"
	"github.com/zeromicro/go-zero/core/logx"
)

func (i *Integration) GetVcListService() (err error) {
	t2 := &vo.VcListRequest{
		Page:       &page.Page{Page: 1, Size: 10},
		Holder:     i.Document.Id,
		Issuer:     DefaultIssuer,
		TemplateId: DefaultTemplateID,
		Status:     -1,
	}

	presentation := core.NewVerifiablePresentation(
		core.DefaultVCContext,
		uuid.GetUUID(),
		DefaultIssuer,
		core.VPType,
		"VerifiablePresentation",
		nil,
		nil,
		time.Now().Add(time.Hour*2),
		t2,
	)

	err = corecrypto.NewSigner(i.PrivateKey, i.Document.Id+"#key-1").Vp(presentation)
	if err != nil {
		return err
	}
	marshal, err := json.Marshal(presentation)
	if err != nil {
		return err
	}
	logx.Info(string(marshal))
	url := i.Runtime.Config.CNBNDID + "/api/v1/did/vc/list"

	_, err = tools.SendRequest("查询vc列表（插件）", url, presentation, i.Runtime.Config.CNBNDID)
	if err != nil {
		return err
	}
	logx.Info("=======================================VcList完成======================================")
	return
}
