package service

import (
	"cnbn-did/didi10n/tools"
	"encoding/json"
	"time"

	"github.com/zeromicro/go-zero/core/logx"

	"chainmaker.org/chainmaker/common/v2/random/uuid"
	"chainweaver.org.cn/chainweaver/did/core"
	corecrypto "chainweaver.org.cn/chainweaver/did/core/crypto"
)

func (i *Integration) VcList() (err error) {
	now := time.Now()
	afterTenMinutes := now.Add(time.Minute * 10)
	extend := `{
		"page": {
			"page": 1,
			"size": 10
		},
		"holder": "did:cnbn:9608c425765b460d885b4142a354d213",
		"issuer": "did:cndid:cndid",
		"templateId": "100000",
		"status": -1
	}
`
	vp := core.NewVerifiablePresentationBytesExtend(
		core.DefaultVCContext,
		uuid.GetUUID(),
		i.Document.Id,
		core.VPType,
		"VerificationAuthorityLegitimacy",
		nil,
		nil,
		afterTenMinutes,
		[]byte(extend))

	bytes, err := json.Marshal(vp)
	if err != nil {
		return
	}

	err = corecrypto.NewSigner(i.PrivateKey, i.Document.Id+"#key-1").Vp(vp)
	if err != nil {
		return
	}

	bytes, err = json.Marshal(vp)
	if err != nil {
		return
	}

	logx.Debugf("VP: %v", string(bytes))

	url := i.Runtime.Config.ApiManage + "/api_manage/api/v1/did/vc/list"
	_, err = tools.SendRequest("api manager 查询 vc 列表", url, vp, i.Runtime.Config.CNBNDID)
	if err != nil {
		return
	}
	logx.Info("=======================================api-manage查询 vc 列表完成======================================")
	return
}
