package service

import (
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"cnbn-did/didi10n/tools"
	"cnbn-did/internal/types"
	"encoding/json"
	"errors"
	"fmt"

	"github.com/zeromicro/go-zero/core/logx"
)

func (i *Integration) GetVcListUser() (vcs []string, err error) {
	vcListUser := types.VcListRequest{
		Page: types.PageVcListUser{
			Page: 1,
			Size: 10,
		},
		Issuer:     DefaultIssuer,
		Holder:     i.Document.Id,
		TemplateId: "",
		Status:     0,
	}
	url := i.Runtime.Config.CNBNDID + "/api/v1/did/vc/list/user"
	bytes, err := tools.SendRequest("查询vc列表（User）", url, vcListUser, i.Runtime.Config.CNBNDID)
	if err != nil {
		return nil, err
	}

	response := &types.VcListResponse{}
	err = json.Unmarshal(bytes, response)
	if err != nil {
		return nil, err
	}
	if res.OK.Code().NotEqualsInt32(response.Code) {
		return nil, errors.New(fmt.Sprintf("VcListResponse error %v, %v", response.Code, response.Msg))
	}
	for _, item := range response.Data.List {
		vcs = append(vcs, string(item.Vc))
	}
	logx.Info("=======================================GetVcListUser完成======================================")
	return vcs, nil
}
