package service

import (
	"cnbn-did/didi10n/tools"
	"encoding/json"
	"time"

	"chainmaker.org/chainmaker/common/v2/random/uuid"
	"chainweaver.org.cn/chainweaver/did/core"
	corecrypto "chainweaver.org.cn/chainweaver/did/core/crypto"
	"github.com/zeromicro/go-zero/core/logx"
)

func (i *Integration) VerifyRandom() (err error) {
	now := time.Now()
	afterTenMinutes := now.Add(time.Minute * 10000000)
	extend := `{
		"appId": "c0e37c34-fd37-4811-9939-7d5647f8a5d6"
	}
`
	vp := core.NewVerifiablePresentationBytesExtend(
		core.DefaultVCContext,
		uuid.GetUUID(),
		i.Document.Id,
		core.VPType,
		"VerificationAuthorityLegitimacy",
		nil,
		nil,
		afterTenMinutes,
		[]byte(extend))

	bytes, err := json.Marshal(vp)
	if err != nil {
		return
	}

	err = corecrypto.NewSigner(i.PrivateKey, i.Document.Id+"#key-1").Vp(vp)
	if err != nil {
		return
	}

	bytes, err = json.Marshal(vp)
	if err != nil {
		return
	}

	logx.Debug("VP: %v", string(bytes))

	url := i.Runtime.Config.ApiManage + "/api_manage/api/v1/did/verify/random"
	_, err = tools.SendRequest("api manager 校验随机数", url, vp, i.Runtime.Config.CNBNDID)
	if err != nil {
		return
	}
	logx.Info("=======================================api-manage校验随机数完成======================================")
	return
}
