package tools

import (
	"bytes"
	"crypto/tls"
	"encoding/json"
	"fmt"
	"io"
	"net/http"
	"path/filepath"
	"strings"

	"chainmaker.org/chainmaker/opennet/servicecommon/res/code"

	"chainmaker.org/chainmaker/opennet/servicecommon/res/rest"
	sdk "chainmaker.org/chainmaker/sdk-go/v2"
	"github.com/zeromicro/go-zero/core/logx"
)

type ServiceContext struct {
	CMClient *sdk.ChainClient
}

func SendRequest(describe string, url string, payload interface{}, cnbnPrefix string) (body []byte, err error) {
	marshal, err := json.Marshal(payload)
	if err != nil {
		panic(err)
	}
	client := &http.Client{}
	if strings.HasPrefix(url, "https://") {
		tr := &http.Transport{
			TLSClientConfig: &tls.Config{InsecureSkipVerify: true},
		}
		client.Transport = tr
	}

	logx.Info(describe + " " + "url: " + url)
	logx.Debugf("\nrequest: \n%v \n", string(marshal))

	reader := bytes.NewReader(marshal)

	req, _ := http.NewRequest("POST", url, reader)

	req.Header.Add("x-token", "{{ssoToken}}")
	req.Header.Add("password", "8u48934978897")
	req.Header.Add("test_opennet_web_url", cnbnPrefix)
	req.Header.Add("content-type", "application/json")

	response, err := client.Do(req)
	if err != nil {
		panic(err)
	}
	defer func(Body io.ReadCloser) {
		err := Body.Close()
		if err != nil {

		}
	}(response.Body)
	body, err = io.ReadAll(response.Body)
	if err != nil {
		panic("os read all failed: " + err.Error())
	}
	res := rest.R{}
	err = json.Unmarshal(body, &res)
	if err != nil {
		panic(fmt.Sprintf("error: %v\n, body: %v", err, string(body)))
	}

	if !code.CodeOk.Equals(res.Code) {
		panic(fmt.Sprintf("response code not 200000, code: %v, msg: %v", res.Code, res.Message))
	}

	logx.Debugf("response: \n%v \n", string(body))
	return body, nil
}

func OutPutEnv(path string, template string) (env, t string) {
	_, file := filepath.Split(path)
	if file == "config-dev.yaml" {
		env = "Dev"
	} else if file == "config-hy.yaml" {
		env = "Hy-dev"
	} else if file == "config-hy-pre.yaml" {
		env = "Hy-pre"
	} else if file == "config-pre.yaml" {
		env = "Pre"
	}
	_, templateFile := filepath.Split(template)
	if templateFile == "100000.json" {
		t = "个人"
	} else if file == "100001.json" {
		t = "企业"
	}
	return env, t
}
