package errorcode

import "chainmaker.org/chainmaker/opennet/servicecommon/res"

const (
	CommonMarshalExceptionCode = 103100 + iota
	CommonUnmarshalExceptionCode
	CommonRequestCopyFailedCode
	CommonResponseCopyFailedCode
	CommonConvertRequestToPbFailedCode
	CommonCallServiceFailedCode
	InputExceptionCode
	ServiceResultExceptionCode
)

var (
	CommonMarshalException         = res.ErrorMessageCode(CommonMarshalExceptionCode, "序列化失败")
	CommonUnmarshalException       = res.ErrorMessageCode(CommonUnmarshalExceptionCode, "反序列化失败")
	CommonRequestCopyFailed        = res.ErrorMessageCode(CommonRequestCopyFailedCode, "复制请求失败")
	CommonResponseCopyFailed       = res.ErrorMessageCode(CommonRequestCopyFailedCode, "复制响应失败")
	CommonConvertRequestToPbFailed = res.ErrorMessageCode(CommonConvertRequestToPbFailedCode, "转换异常")
	CommonCallServiceFailed        = res.ErrorMessageCode(CommonCallServiceFailedCode, "服务异常")
	InputException                 = res.ErrorMessageCode(InputExceptionCode, "参数异常")
	ServiceResultException         = res.ErrorMessageCode(ServiceResultExceptionCode, "结果异常")
)
