/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package blacklist

import (
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"cnbn-did/internal/logic/blacklist"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"
	"net/http"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func CheckHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.CheckRequest
		if err := httpx.Parse(r, &req); err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ParameterError.AddError(err).AddMessage("CheckHandler").BuildRESTful())
			return
		}

		l := blacklist.NewCheckLogic(r.Context(), svcCtx)
		resp, err := l.Check(&req)
		if err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ServiceError.AddError(err).AddMessage("CheckHandler").BuildRESTful())
		} else {
			httpx.OkJsonCtx(r.Context(), w, resp)
		}
	}
}
