/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package did

import (
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"encoding/json"
	"io"
	"net/http"

	"cnbn-did/internal/logic/did"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func RegisterHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.DidRegisterRequest
		bytes, err := io.ReadAll(r.Body)
		if err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ParameterError.AddError(err).AddMessage("RegisterHandler读取Body失败").BuildRESTful())
			return
		}
		if err := json.Unmarshal(bytes, &req); err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ParameterError.AddError(err).AddMessage("RegisterHandler Unmarshal失败").BuildRESTful())
			return
		}

		l := did.NewRegisterLogic(r.Context(), svcCtx)
		resp, err := l.Register(&req)
		if err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ServiceError.AddError(err).AddMessage("RegisterHandler").BuildRESTful())
			return
		} else {
			httpx.OkJsonCtx(r.Context(), w, resp)
		}
	}
}
