/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package document

import (
	"net/http"

	"cnbn-did/internal/logic/document"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func GetDocumentByAddressHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.DocumentGetByAddressRequest
		if err := httpx.Parse(r, &req); err != nil {
			httpx.ErrorCtx(r.Context(), w, err)
			return
		}

		l := document.NewGetDocumentByAddressLogic(r.Context(), svcCtx)
		resp, err := l.GetDocumentByAddress(&req)
		if err != nil {
			httpx.ErrorCtx(r.Context(), w, err)
		} else {
			httpx.OkJsonCtx(r.Context(), w, resp)
		}
	}
}
