/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package generate

import (
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"net/http"

	"cnbn-did/internal/logic/generate"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func UpdateDocumentVerificationMethodHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.GenUpdateDocumentVerificationMethodRequest
		if err := httpx.Parse(r, &req); err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ParameterError.AddError(err).AddMessage("UpdateDocumentVerificationMethodHandler").BuildRESTful())
			return
		}

		l := generate.NewUpdateDocumentVerificationMethodLogic(r.Context(), svcCtx)
		resp, err := l.UpdateDocumentVerificationMethod(&req)
		if err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ServiceError.AddError(err).AddMessage("UpdateDocumentVerificationMethodHandler").BuildRESTful())
			return
		} else {
			httpx.OkJsonCtx(r.Context(), w, resp)
		}
	}
}
