/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package inner

import (
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"net/http"

	"cnbn-did/internal/logic/inner"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func UpdateVcTemplateHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.VcTemplateUpgradeRequest
		if err := httpx.Parse(r, &req); err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ParameterError.AddError(err).AddMessage("UpdateVcTemplateHandler").BuildRESTful())
			return
		}

		l := inner.NewUpdateVcTemplateLogic(r.Context(), svcCtx)
		resp, err := l.UpdateVcTemplate(&req)
		if err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ServiceError.AddError(err).AddMessage("UpdateVcTemplateHandler").BuildRESTful())
		} else {
			httpx.OkJsonCtx(r.Context(), w, resp)
		}
	}
}
