/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package issuelog

import (
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"net/http"

	"cnbn-did/internal/logic/issuelog"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func GetVcIssuersHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.IssueLogGetVcIssuersRequest
		if err := httpx.Parse(r, &req); err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ParameterError.AddError(err).AddMessage("GetVcIssuersHandler").BuildRESTful())
			return
		}

		l := issuelog.NewGetVcIssuersLogic(r.Context(), svcCtx)
		resp, err := l.GetVcIssuers(&req)
		if err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ServiceError.AddError(err).AddMessage("GetVcIssuersHandler").BuildRESTful())
			return
		} else {
			httpx.OkJsonCtx(r.Context(), w, resp)
		}
	}
}
