/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package trustissuer

import (
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"net/http"

	"cnbn-did/internal/logic/trustissuer"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func AddHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.TrustIssuerAddRequest
		if err := httpx.Parse(r, &req); err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ParameterError.AddError(err).AddMessage("AddTrustIssuerHandler").BuildRESTful())
			return
		}

		l := trustissuer.NewAddLogic(r.Context(), svcCtx)
		resp, err := l.Add(&req)
		if err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ServiceError.AddError(err).AddMessage("AddTrustIssuerHandler").BuildRESTful())
			return
		} else {
			httpx.OkJsonCtx(r.Context(), w, resp)
		}
	}
}
