/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package vc

import (
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"cnbn-did/internal/logic/vc"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"
	"net/http"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func CheckListHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.CheckListRequest
		if err := httpx.Parse(r, &req); err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ParameterError.AddError(err).AddMessage("VcCheckListHandler").BuildRESTful())
			return
		}

		l := vc.NewCheckListLogic(r.Context(), svcCtx)
		resp, err := l.CheckList(&req)
		if err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ServiceError.AddError(err).AddMessage("VcCheckListHandler").BuildRESTful())
		} else {
			httpx.OkJsonCtx(r.Context(), w, resp)
		}
	}
}
