/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package vc

import (
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"net/http"

	"cnbn-did/internal/logic/vc"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func FindCompanyNameByDIDHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.FindCompanyNameByDIDRequest
		if err := httpx.Parse(r, &req); err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ParameterError.AddError(err).AddMessage("FindCompanyNameByDIDHandler").BuildRESTful())
			return
		}

		l := vc.NewFindCompanyNameByDIDLogic(r.Context(), svcCtx)
		resp, err := l.FindCompanyNameByDID(&req)
		if err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ServiceError.AddError(err).AddMessage("FindCompanyNameByDIDHandler").BuildRESTful())
		} else {
			httpx.OkJsonCtx(r.Context(), w, resp)
		}
	}
}
