/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package vc

import (
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"encoding/json"
	"io"
	"net/http"

	"cnbn-did/internal/logic/vc"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func VcRevokeHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.VerifiablePresentation
		bytes, err := io.ReadAll(r.Body)
		if err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ParameterError.AddError(err).AddMessage("CreateVcIssueHandler读取Body失败").BuildRESTful())
			return
		}
		if err := json.Unmarshal(bytes, &req); err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ParameterError.AddError(err).AddMessage("CreateVcIssueHandler Unmarshal失败").BuildRESTful())
			return
		}

		l := vc.NewVcRevokeLogic(r.Context(), svcCtx)
		resp, err := l.VcRevoke(&req)
		if err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ServiceError.AddError(err).AddMessage("VcRevokeHandler").BuildRESTful())
			return
		} else {
			httpx.OkJsonCtx(r.Context(), w, resp)
		}
	}
}
