package vctemplate

import (
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"net/http"

	"cnbn-did/internal/logic/vctemplate"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"
	"github.com/zeromicro/go-zero/rest/httpx"
)

func CreatevctemplateHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.VcTemplateSaveRequest
		if err := httpx.Parse(r, &req); err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ParameterError.AddError(err).AddMessage("CreatevctemplateHandler").BuildRESTful())
			return
		}

		l := vctemplate.NewCreatevctemplateLogic(r.Context(), svcCtx)
		resp, err := l.Createvctemplate(&req)
		if err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ServiceError.AddError(err).AddMessage("CreatevctemplateHandler").BuildRESTful())
			return
		} else {
			httpx.OkJson(w, resp)
		}
	}
}
